#delimit;
clear;
set more off;
set memory 1500m;
set matsize 1000;
global basedirectory "C:\Files\published\gas\upload data\Pop Density from Census\";
graph set eps fontface Garamond;
graph set print logo off;

*CENSUS REPORTS POPULATION BY STATE AS OF JULY OF EACH YEAR;
*Table 2 of CURRENT POPULATION REPORTS Series, P25-1106, Intercensal Estimates of the Total Resident Population of States: 1980 to 1990;
*Source: Population Division, U.S. Census Bureau;
*Table CO-EST2001-12-00 - Time Series of Intercensal State Population Estimates: 1990 to 2000;
*Source: Population Division, U.S. Census Bureau;
*Table 1: Annual Estimates of the Resident Population for the United States, Regions, States, and Puerto Rico: 2000 to 2008 (NST-EST2008-01)
*Source: Population Division, U.S. Census Bureau;
*Total Land Area; 
*Source: U.S. Census Bureau, Census 2000 Summary File 1;

insheet using "${basedirectory}PopDensity1980s.csv", clear; gen statefip=.;   
replace statefip=1 if state=="AL";  replace statefip=2 if state=="AK";  replace statefip=4 if state=="AZ";  replace statefip=5 if state=="AR";
replace statefip=6 if state=="CA";  replace statefip=8 if state=="CO";  replace statefip=9 if state=="CT";  replace statefip=10 if state=="DE";
replace statefip=11 if state=="DC"; replace statefip=12 if state=="FL"; replace statefip=13 if state=="GA"; replace statefip=15 if state=="HI";
replace statefip=16 if state=="ID"; replace statefip=17 if state=="IL"; replace statefip=18 if state=="IN"; replace statefip=19 if state=="IA";
replace statefip=20 if state=="KS"; replace statefip=21 if state=="KY"; replace statefip=22 if state=="LA"; replace statefip=23 if state=="ME";
replace statefip=24 if state=="MD"; replace statefip=25 if state=="MA"; replace statefip=26 if state=="MI"; replace statefip=27 if state=="MN";
replace statefip=28 if state=="MS"; replace statefip=29 if state=="MO"; replace statefip=30 if state=="MT"; replace statefip=31 if state=="NE";
replace statefip=32 if state=="NV"; replace statefip=33 if state=="NH"; replace statefip=34 if state=="NJ"; replace statefip=35 if state=="NM";
replace statefip=36 if state=="NY"; replace statefip=37 if state=="NC"; replace statefip=38 if state=="ND"; replace statefip=39 if state=="OH";
replace statefip=40 if state=="OK"; replace statefip=41 if state=="OR"; replace statefip=42 if state=="PA"; replace statefip=44 if state=="RI";
replace statefip=45 if state=="SC"; replace statefip=46 if state=="SD"; replace statefip=47 if state=="TN"; replace statefip=48 if state=="TX";
replace statefip=49 if state=="UT"; replace statefip=50 if state=="VT"; replace statefip=51 if state=="VA"; replace statefip=53 if state=="WA";
replace statefip=54 if state=="WV"; replace statefip=55 if state=="WI"; replace statefip=56 if state=="WY"; drop state; sort statefip;
save temp1.dta, replace;

insheet using "${basedirectory}PopDensity1990s.csv", clear; gen statefip=.;   
replace statefip=1 if statename=="Alabama"; replace statefip=2 if statename=="Alaska"; replace statefip=4 if statename=="Arizona";  
replace statefip=5 if statename=="Arkansas"; replace statefip=6 if statename=="California"; replace statefip=8 if statename=="Colorado";  
replace statefip=9 if statename=="Connecticut"; replace statefip=10 if statename=="Delaware"; replace statefip=11 if statename=="District of Columbia"; 
replace statefip=12 if statename=="Florida"; replace statefip=13 if statename=="Georgia"; replace statefip=15 if statename=="Hawaii";
replace statefip=16 if statename=="Idaho"; replace statefip=17 if statename=="Illinois"; replace statefip=18 if statename=="Indiana"; 
replace statefip=19 if statename=="Iowa"; replace statefip=20 if statename=="Kansas"; replace statefip=21 if statename=="Kentucky"; 
replace statefip=22 if statename=="Louisiana"; replace statefip=23 if statename=="Maine"; replace statefip=24 if statename=="Maryland"; 
replace statefip=25 if statename=="Massachusetts"; replace statefip=26 if statename=="Michigan"; replace statefip=27 if statename=="Minnesota";
replace statefip=28 if statename=="Mississippi"; replace statefip=29 if statename=="Missouri"; replace statefip=30 if statename=="Montana"; 
replace statefip=31 if statename=="Nebraska"; replace statefip=32 if statename=="Nevada"; replace statefip=33 if statename=="New Hampshire"; 
replace statefip=34 if statename=="New Jersey"; replace statefip=35 if statename=="New Mexico"; replace statefip=36 if statename=="New York"; 
replace statefip=37 if statename=="North Carolina"; replace statefip=38 if statename=="North Dakota"; replace statefip=39 if statename=="Ohio";
replace statefip=40 if statename=="Oklahoma"; replace statefip=41 if statename=="Oregon"; replace statefip=42 if statename=="Pennsylvania"; 
replace statefip=44 if statename=="Rhode Island"; replace statefip=45 if statename=="South Carolina"; replace statefip=46 if statename=="South Dakota"; 
replace statefip=47 if statename=="Tennessee"; replace statefip=48 if statename=="Texas"; replace statefip=49 if statename=="Utah"; 
replace statefip=50 if statename=="Vermont"; replace statefip=51 if statename=="Virginia"; replace statefip=53 if statename=="Washington";
replace statefip=54 if statename=="West Virginia"; replace statefip=55 if statename=="Wisconsin"; replace statefip=56 if statename=="Wyoming";
drop statename; sort statefip; merge statefip using temp1.dta; 
assert _merge==3; drop _merge; sort statefip; save temp1.dta, replace;

insheet using "${basedirectory}PopDensity2000s.csv", clear; gen statefip=.;   
replace statefip=1 if statename=="Alabama"; replace statefip=2 if statename=="Alaska"; replace statefip=4 if statename=="Arizona";  
replace statefip=5 if statename=="Arkansas"; replace statefip=6 if statename=="California"; replace statefip=8 if statename=="Colorado";  
replace statefip=9 if statename=="Connecticut"; replace statefip=10 if statename=="Delaware"; replace statefip=11 if statename=="District of Columbia"; 
replace statefip=12 if statename=="Florida"; replace statefip=13 if statename=="Georgia"; replace statefip=15 if statename=="Hawaii";
replace statefip=16 if statename=="Idaho"; replace statefip=17 if statename=="Illinois"; replace statefip=18 if statename=="Indiana"; 
replace statefip=19 if statename=="Iowa"; replace statefip=20 if statename=="Kansas"; replace statefip=21 if statename=="Kentucky"; 
replace statefip=22 if statename=="Louisiana"; replace statefip=23 if statename=="Maine"; replace statefip=24 if statename=="Maryland"; 
replace statefip=25 if statename=="Massachusetts"; replace statefip=26 if statename=="Michigan"; replace statefip=27 if statename=="Minnesota";
replace statefip=28 if statename=="Mississippi"; replace statefip=29 if statename=="Missouri"; replace statefip=30 if statename=="Montana"; 
replace statefip=31 if statename=="Nebraska"; replace statefip=32 if statename=="Nevada"; replace statefip=33 if statename=="New Hampshire"; 
replace statefip=34 if statename=="New Jersey"; replace statefip=35 if statename=="New Mexico"; replace statefip=36 if statename=="New York"; 
replace statefip=37 if statename=="North Carolina"; replace statefip=38 if statename=="North Dakota"; replace statefip=39 if statename=="Ohio";
replace statefip=40 if statename=="Oklahoma"; replace statefip=41 if statename=="Oregon"; replace statefip=42 if statename=="Pennsylvania"; 
replace statefip=44 if statename=="Rhode Island"; replace statefip=45 if statename=="South Carolina"; replace statefip=46 if statename=="South Dakota"; 
replace statefip=47 if statename=="Tennessee"; replace statefip=48 if statename=="Texas"; replace statefip=49 if statename=="Utah"; 
replace statefip=50 if statename=="Vermont"; replace statefip=51 if statename=="Virginia"; replace statefip=53 if statename=="Washington";
replace statefip=54 if statename=="West Virginia"; replace statefip=55 if statename=="Wisconsin"; replace statefip=56 if statename=="Wyoming";
drop statename; sort statefip; merge statefip using temp1.dta; assert _merge==3; drop _merge; erase temp1.dta;

*EACH UNIT OF OBSERVATION IS STATE MONTH;
reshape long y, i(statefip) j(year); rename y population;
drop if statefip==.;  *Drop U.S.;
gen density=population/sqmiles; 
drop population sqmiles;

*INTERPOLATE FOR ALL MONTHS;
gen date=year*12; drop year;
tsset statefip date; tsfill, full;
gen year=floor(date/12); gen month=date-year*12+1;
bysort statefip: ipolate density date, gen(popdensity);

*REMEMBER, CENSUS DESCRIBES POPULATION AS OF JULY;
replace year=year+1 if month>6; gen Month=.; 
replace Month=7  if month==1;  replace Month=8  if month==2;
replace Month=9  if month==3;  replace Month=10 if month==4;
replace Month=11 if month==5;  replace Month=12 if month==6;
replace Month=1  if month==7;  replace Month=2  if month==8;
replace Month=3  if month==9;  replace Month=4  if month==10;
replace Month=5  if month==11; replace Month=6  if month==12;
drop month; rename Month month;

*EXPORT;
keep statefip year month popdensity;
drop if year<1989; drop if year==2008 & month>3;
sort statefip year month; save "${basedirectory}popdensity.dta", replace;

